function [dist,vector,lum] = punc2mat_lite(punc_data)
%A Little function that takes the punc_data structure created by
%punc_metrics and convertes it into a matrix for easy manipulation.
%Synatax:   [distance,vector,lum,sl_dist,sl_vector,sl_lum] = punc2mat(punc_data);
%Input:     punc_data = data structure created by punc_data
%
%Output:    dist = structure of distance matrices. distance(x).ch
%                   x = # of channels.  For distance(1).ch = a cell array,
%                   where the z is # of channels.  On x: Index, vertex, 2nd
%                   vertex, distance.  x y form an array.
%           vector = structure of vector matrices. vector(x).ch. x = # of
%                   channels.  For vector(1).ch = a cell array, where the z
%                   is # of channels.  x y is an cell of matrices.
%                   Essentially, x = # of vertices for current channel.  y
%                   is always going to be 1.  For each cell x y, there is a
%                   matrix of a b c, where c = # of channels - 2, the two
%                   points making up the base vector.  a b is an array,
%                   where on a: index, start_pt, base_termini,
%                   comp_termini, xy, xy_pos, xz, xz_pos, xyz. b = # of
%                   vertices in the comparision channel that is in the
%                   nhood of the vertex in the current channel.
%           lum = the luminance value for the vertices, matches dist and
%                   vector data structure.
%           sl_dist = distance structure for short list instead of the
%                   closest vertices.
%           sl_vector = vector structure for short list instead of the
%                   closese vertices.
%           sl_lum = luminance structure of short list.
%           Note: cases were angle data is NaN is when the dot product and
%           the magnitudes of the base vectors are 0, essentially meaning
%           the two points are right on top of one another.  Might need to
%           deal with that at some point.

%lets get the distance matrices done.
%h = waitbar(0,['Data Sets Analyzed: ',punc_data(1).filenames{1}],'position',[20 300 275 50]);    %initialize progress bar.
%pull out some useful info
nrst_only = punc_data(1).nrst_only;
ori = punc_data(1).ori;
termi = punc_data(1).termi;
try         %if there the .vector field use it, if it is not present, assume vector = 0;
    vect = punc_data(1).vector;
catch
    vect = 0;
end
i = ori;
try
    chan = size(punc_data(i).dist_verti,3);     %number of channels
    verti = size(punc_data(i).dist_verti,1);    %number of vertices
catch
    chan = size(punc_data(i).sl_dist,3);
    verti = size(punc_data(i).sl_dist,1);
end

%begin parallelization
%matlabpool      %initiate threads

dist = cell(1,1,chan);      %initialize the cell array
lum = cell(1,1,chan);
for j = 1:chan %step through the number of comparision channels.
    dist_tmp = cell(verti,1);       %initialize the temp cell array
    lum_tmp = cell(verti,1);
    if nrst_only
        if ~isempty(cell2mat(punc_data(i).dist_verti(:,:,j)))   %proceed if this channel have values
            parfor k = 1:verti   %step through vertices of curr channel
                %pull out and create a array of data for each vertices.
                curr_tmp = horzcat(repmat(k,size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).verti_match{k,1,j},...
                    repmat(punc_data(i).v_match_lum{k,1,i},size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).closest_pt{k,1,j},...
                    punc_data(i).dist_verti{k,1,j});
                curr_lum_tmp = horzcat(repmat(k,size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).verti_match{k,1,j},...
                    repmat(punc_data(i).v_match_lum{k,1,i},size(punc_data(i).verti_match{k,1,j},1),1),punc_data(i).closest_pt{k,1,j},...
                    punc_data(i).closest_pt_lum{k,1,j});
                %now form the larger arrays
                dist_tmp{k} = curr_tmp;
                lum_tmp{k} = curr_lum_tmp;
            end
            %clear curr_tmp curr_lum_tmp
            curr_tmp = []; curr_lum_tmp = [];
            %one array is ready for output
            dist{1,1,j} = cell2mat(dist_tmp);
            lum{1,1,j} = cell2mat(lum_tmp);
        end
    else
        if ~isempty(cell2mat(punc_data(i).sl_dist(:,:,j)))   %proceed if this channel have values
            parfor k = 1:verti   %step through vertices of curr channel
                %pull out and create a array of data for each vertices in the short list.
                sl_curr_tmp = horzcat(repmat(k,size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).sl_verti_match{k,1,j},...
                    repmat(punc_data(i).sl_v_match_lum{k,1,i},size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).short_list{k,1,j},...
                    punc_data(i).sl_dist{k,1,j});
                sl_curr_lum_tmp = horzcat(repmat(k,size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).sl_verti_match{k,1,j},...
                    repmat(punc_data(i).sl_v_match_lum{k,1,i},size(punc_data(i).sl_verti_match{k,1,j},1),1),punc_data(i).short_list{k,1,j},...
                    punc_data(i).short_list_lum{k,1,j});
                dist_tmp{k} = sl_curr_tmp;
                lum_tmp{k} = sl_curr_lum_tmp;
            end
            %clear curr_tmp curr_lum_tmp
            sl_curr_tmp = []; sl_curr_lum_tmp = [];
            %one array is ready for output
            dist{1,1,j} = cell2mat(dist_tmp);
            lum{1,1,j} = cell2mat(lum_tmp);
        end
    end
    dist_tmp = []; lum_tmp = [];
end
%clear the tmp files
clear dist_tmp lum_tmp curr_tmp curr_lum_tmp

%lets get cracking on the vector matrices
%parse to see if the nearest vertices are calculated or not.
if vect
    h2 = waitbar(0,['Comparing Data Set: ',punc_data(1).filenames{1}],'position',[20 200 275 50]);    %initialize progress bar.
    vector = cell(verti,1,chan);
    for j = 1:chan  %step through base channels/vectors
        if nrst_only
            if ~isempty(cell2mat(punc_data(i).verti_match(:,:,j)))   %proceed if this channel have values
                parfor k = 1:verti  %process every vertices
                    angles = cell(1,1,size(punc_data(i).angles_xy,2));
                    for m = 1:size(punc_data(i).angles_xy,2)    %number of compared channels.
                        %intiate temp
                        angles_tmp = cell(size(punc_data(i).verti_match{k,1,j},1),1);
                        try
                            cell2mat(punc_data(i).angles_xy(:,m,j));    %proceed if the column is not empty, which is if this errors
                        catch
                            %process the nearest angles first
                            for l = 1:size(punc_data(i).verti_match{k,1,j},1)   %process all of the nearest points
                                x = size(cell2mat(punc_data(i).angles_xy{k,m,j}(l,:)),1);      %number of vectors compared to the base vector
                                %for the array
                                curr_angles_tmp = horzcat(repmat(k,x,1),repmat(punc_data(i).vertices(k,:),x,1),...
                                    repmat(punc_data(i).closest_pt{k,1,j}(l,:),x,1),punc_data(i).closest_pt{k,1,m},...
                                    cell2mat(punc_data(i).angles_xy{k,m,j}(l,:)),cell2mat(punc_data(i).angles_pos_xy{k,m,j}(l,:)),...
                                    cell2mat(punc_data(i).angles_xz{k,m,j}(l,:)),cell2mat(punc_data(i).angles_pos_xz{k,m,j}(l,:)),...
                                    cell2mat(punc_data(i).angles_xyz{k,m,j}(l,:)));
                                angles_tmp{l} = curr_angles_tmp;
                            end
                        end
                        %now store that matrix in a cell array for all channels
                        %analyzed
                        angles{:,:,m} = cell2mat(angles_tmp);
                    end
                    %now store that cell array in a cell array for all
                    %verticies in that channel & output
                    vector{k,1,j} = angles;
                end
            end
        else
            if ~isempty(cell2mat(punc_data(i).sl_verti_match(:,:,j)))   %proceed if this channel have values
                parfor k = 1:verti  %process every vertices
                    angles = cell(1,1,size(punc_data(i).sl_angles_xy,2));
                    for m = 1:size(punc_data(i).sl_angles_xy,2)    %number of compared channels.
                        %intiate temp
                        angles_tmp = cell(size(punc_data(i).short_list{k,1,j},1),1);
                        try
                            cell2mat(punc_data(i).sl_angles_xy(:,m,j));    %proceed if the column is not empty, which is this errors
                        catch
                            %process the short list angles next
                            for l = 1:size(punc_data(i).short_list{k,1,j},1)   %process all of the nearest points
                                x = size(cell2mat(punc_data(i).sl_angles_xy{k,m,j}(l,:)),1);      %number of vectors compared to the base vector
                                %for the array
                                curr_sl_angles_tmp = horzcat(repmat(k,x,1),repmat(punc_data(i).vertices(k,:),x,1),...
                                    repmat(punc_data(i).short_list{k,1,j}(l,:),x,1),punc_data(i).short_list{k,1,m},...
                                    cell2mat(punc_data(i).sl_angles_xy{k,m,j}(l,:)),cell2mat(punc_data(i).sl_angles_pos_xy{k,m,j}(l,:)),...
                                    cell2mat(punc_data(i).sl_angles_xz{k,m,j}(l,:)),cell2mat(punc_data(i).sl_angles_pos_xz{k,m,j}(l,:)),...
                                    cell2mat(punc_data(i).sl_angles_xyz{k,m,j}(l,:)));
                                angles_tmp{l} = curr_sl_angles_tmp;  %creates a matrix for all comparisions against a single base vector in chx.
                            end
                        end
                        %now store that matrix in a cell array for all channels
                        %analyzed
                        angles{:,:,m} = cell2mat(angles_tmp);
                    end
                    %now store that cell array in a cell array for all
                    %verticies in that channel & output
                    vector{k,1,j} = angles;
                end
            end
        end
        waitbar(j/chan,h2,['Comparing Data Set: ',punc_data(1).filenames{j}]);   %update progress
    end
end
close(h2);
%closing time
%matlabpool close